﻿using VA.TMP.Integration.VIMT.Vista.Mappers;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;
using VA.TMP.Integration.VIMT.Vista.Links;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.GroupCancelAppointment
{
    public class MapToPatGroupCancelRequestStep:FilterBase<CancelGroupAppointmentStateObject>
    {
        public override void Execute(CancelGroupAppointmentStateObject state)
        {
            state.PatEcRequest = CancelAppointmentMapper.CancelAppointmentRequest(state, Side.Patient, Logger.Instance);

            if (!string.IsNullOrEmpty(state.PatUserDuz))
                state.PatEcRequest.VIMTVIASchedCancApReqqueryBeanInfo.VIMTVIASchedCancApReqproviderInfo.mcs_userId = state.PatUserDuz;
            else
            {
                var siteNum = state.PatEcRequest.VIMTVIASchedCancApReqqueryBeanInfo.VIMTVIASchedCancApReqproviderInfo.mcs_loginSiteCode;
                state.PatLoginRequest = new LoginMapper().GetLoginRequest(state.UserId, siteNum, state.OrganizationServiceProxy, state.SamlToken);
            }
        }
    }
}
